import { Role, UserPage, UserRoleTO } from "src/framework/domain";
export interface UserRoleRepository {
    save(userId: number, roleId: number): Promise<boolean>;
    getRolesByUserId(userId: number): Promise<string[]>;
    getAdminUserIds(): Promise<number[]>;
    updateRoles(params: UserRoleTO, profileId: number): Promise<boolean | undefined>;
    getAllPaginated(page: number, pageSize: number, profileId: number): Promise<UserPage[]>;
    getUserRoles(userId: number): Promise<Role[]>;
}
