"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpdateRole = exports.Role = exports.InsertRole = void 0;
const swagger_1 = require("@nestjs/swagger");
const allow_roles_decorator_1 = require("../../infrastructure/decorators/allow-profiles/allow-roles.decorator");
class Role {
    constructor(id, name, shortName) {
        this.id = id;
        this.name = name;
        this.shortName = shortName;
    }
}
exports.Role = Role;
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Role id',
        example: 1,
    }),
    __metadata("design:type", Number)
], Role.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Role name',
        example: 'Administrator',
        required: false,
    }),
    __metadata("design:type", String)
], Role.prototype, "name", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Role key search',
        example: allow_roles_decorator_1.RoleShortNameEnum.USER,
        enum: allow_roles_decorator_1.RoleShortNameEnum,
        enumName: 'RoleShortNameEnum',
    }),
    __metadata("design:type", String)
], Role.prototype, "shortName", void 0);
class InsertRole extends (0, swagger_1.OmitType)(Role, ['id']) {
}
exports.InsertRole = InsertRole;
class UpdateRole extends (0, swagger_1.PartialType)(InsertRole) {
}
exports.UpdateRole = UpdateRole;
//# sourceMappingURL=role.entity.js.map