"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var AccessController_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AccessController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const definition_1 = require("../../definition");
const domain_1 = require("../../../domain");
const decoded_token_decorator_1 = require("../../decorators/decoded-token/decoded-token.decorator");
const access_token_decorator_1 = require("../../decorators/access-token/access-token.decorator");
const util_1 = require("util");
const api_default_responses_decorator_1 = require("../../decorators/api-default-responses/api-default-responses.decorator");
const prime_user_decorator_1 = require("../../decorators/prime-user/prime-user.decorator");
const config_1 = require("@nestjs/config");
let AccessController = AccessController_1 = class AccessController {
    constructor(userService, userRoleService, configService) {
        this.userService = userService;
        this.userRoleService = userRoleService;
        this.configService = configService;
        this.LOGGER = new definition_1.PrimeLogger(AccessController_1.name);
        this.latestVersionAndroid = this.configService.get('LATEST_VERSION_ANDROID', '1.0.0+11');
        this.latestVersionIOS = this.configService.get('LATEST_VERSION_IOS', '1.0.0+11');
    }
    async erraseAccount(user) {
        this.LOGGER.log(`erraseAccount user ${user.id}`);
        await this.userService.errase(user);
        this.LOGGER.log(`erraseAccount user ${user.id} deleted`);
        return 'true';
    }
    async recordUserForm(decodedToken, recordTO) {
        this.LOGGER.log(`recordUserForm called with decodedToken: ${(0, util_1.inspect)(decodedToken)}, recordTO: ${(0, util_1.inspect)(recordTO)}`);
        recordTO.user.externalId = decodedToken.sub;
        return {
            result: await this.userService.registerUserByProfile(recordTO),
        };
    }
    async checkStatusSession(user, accessToken) {
        this.LOGGER.log(`checkStatusSession user ${(0, util_1.inspect)(user)}`);
        const profiles = await this.userRoleService.getRolesByUserId(user.id);
        return {
            fullName: user && `${user.name} ${user.lastName != null ? user.lastName : ''} ${user.lastname2 != null ? user.lastname2 : ''}`.trim(),
            token: accessToken,
            cellPhone: user.cellPhone,
            aggrementDate: user.aggrementDate,
            roles: profiles.map(profile => profile).join(', '),
            latestVersionAndroid: this.latestVersionAndroid,
            latestVersionIOS: this.latestVersionIOS,
        };
    }
    async me(user) {
        this.LOGGER.log(`me called with user: ${(0, util_1.inspect)(user)}`);
        return user;
    }
    async unsubscribe(user) {
        this.LOGGER.log(`Unsubscribing user ${user.id}`);
        this.userService.unsubscribe(user);
        return 'true';
    }
};
exports.AccessController = AccessController;
__decorate([
    (0, common_1.Delete)('errase-account'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, swagger_1.ApiConflictResponse)({ type: definition_1.ApiErrorResponse }),
    (0, swagger_1.ApiOkResponse)({ type: String }),
    __param(0, (0, prime_user_decorator_1.PrimeUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [domain_1.User]),
    __metadata("design:returntype", Promise)
], AccessController.prototype, "erraseAccount", null);
__decorate([
    (0, common_1.Post)('record-user'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, swagger_1.ApiOkResponse)({ type: domain_1.RecordOutTO }),
    (0, swagger_1.ApiConflictResponse)({ type: definition_1.ApiErrorResponse }),
    (0, swagger_1.ApiBody)({ type: domain_1.RecordTO }),
    __param(0, (0, decoded_token_decorator_1.DecodedToken)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, domain_1.RecordTO]),
    __metadata("design:returntype", Promise)
], AccessController.prototype, "recordUserForm", null);
__decorate([
    (0, common_1.Get)('check-status'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, swagger_1.ApiOkResponse)({ type: domain_1.LoginOutTO }),
    (0, swagger_1.ApiConflictResponse)({ type: definition_1.ApiErrorResponse }),
    __param(0, (0, prime_user_decorator_1.PrimeUser)()),
    __param(1, (0, access_token_decorator_1.AccessToken)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [domain_1.User, String]),
    __metadata("design:returntype", Promise)
], AccessController.prototype, "checkStatusSession", null);
__decorate([
    (0, common_1.Get)('me'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, swagger_1.ApiOkResponse)({ type: domain_1.User }),
    __param(0, (0, prime_user_decorator_1.PrimeUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [domain_1.User]),
    __metadata("design:returntype", Promise)
], AccessController.prototype, "me", null);
__decorate([
    (0, common_1.Get)('unsubscribe'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, swagger_1.ApiOkResponse)({ type: domain_1.User }),
    __param(0, (0, prime_user_decorator_1.PrimeUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [domain_1.User]),
    __metadata("design:returntype", Promise)
], AccessController.prototype, "unsubscribe", null);
exports.AccessController = AccessController = AccessController_1 = __decorate([
    (0, common_1.Controller)('access'),
    (0, swagger_1.ApiTags)('access'),
    __param(0, (0, common_1.Inject)('UserService')),
    __param(1, (0, common_1.Inject)('UserRoleService')),
    __metadata("design:paramtypes", [Object, Object, config_1.ConfigService])
], AccessController);
//# sourceMappingURL=access.controller.js.map