"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiDefaultResponses = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const definition_1 = require("../../definition");
const ApiDefaultResponses = () => {
    return (0, common_1.applyDecorators)((0, swagger_1.ApiBadRequestResponse)({
        schema: {
            $ref: (0, swagger_1.getSchemaPath)(definition_1.ApiErrorResponse),
            example: definition_1.ApiErrorExamples.BAD_REQUEST,
        },
    }), (0, swagger_1.ApiUnauthorizedResponse)({
        schema: {
            $ref: (0, swagger_1.getSchemaPath)(definition_1.ApiErrorResponse),
            example: definition_1.ApiErrorExamples.UNAUTHORIZED,
        },
    }), (0, swagger_1.ApiForbiddenResponse)({
        schema: {
            $ref: (0, swagger_1.getSchemaPath)(definition_1.ApiErrorResponse),
            example: definition_1.ApiErrorExamples.FORBIDEN,
        },
    }), (0, swagger_1.ApiBearerAuth)());
};
exports.ApiDefaultResponses = ApiDefaultResponses;
//# sourceMappingURL=api-default-responses.decorator.js.map