"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiVehicleResponses = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const definition_1 = require("../../definition");
const ApiVehicleResponses = () => {
    return (0, common_1.applyDecorators)((0, swagger_1.ApiAmbiguousResponse)({
        schema: {
            $ref: (0, swagger_1.getSchemaPath)(definition_1.ApiErrorResponse),
            example: definition_1.ApiErrorExamples.RECORD_EXIST,
        },
    }), (0, swagger_1.ApiBadRequestResponse)({
        schema: {
            $ref: (0, swagger_1.getSchemaPath)(definition_1.ApiErrorResponse),
            example: definition_1.ApiErrorExamples.BAD_REQUEST,
        },
    }), (0, swagger_1.ApiUnauthorizedResponse)({
        schema: {
            $ref: (0, swagger_1.getSchemaPath)(definition_1.ApiErrorResponse),
            example: definition_1.ApiErrorExamples.UNAUTHORIZED,
        },
    }), (0, swagger_1.ApiForbiddenResponse)({
        schema: {
            $ref: (0, swagger_1.getSchemaPath)(definition_1.ApiErrorResponse),
            example: definition_1.ApiErrorExamples.FORBIDEN,
        },
    }), (0, swagger_1.ApiBearerAuth)());
};
exports.ApiVehicleResponses = ApiVehicleResponses;
//# sourceMappingURL=api-vehicle-responses.decorator.js.map