import { ArgumentsHost, ExceptionFilter, HttpStatus } from '@nestjs/common';
import { ExceptionType } from '../';
export declare class ApiErrorResponse {
    status: number;
    message: string;
    type: ExceptionType;
}
export declare class ApiErrorExamples {
    static readonly RECORD_EXIST: {
        status: HttpStatus;
        message: string;
        type: ExceptionType;
    };
    static readonly FORBIDEN: {
        status: HttpStatus;
        message: string;
        type: ExceptionType;
    };
    static readonly NOT_FOUND: {
        status: HttpStatus;
        message: string;
        type: ExceptionType;
    };
    static readonly UNAUTHORIZED: {
        status: HttpStatus;
        message: string;
        type: ExceptionType;
    };
    static readonly BAD_REQUEST: {
        status: HttpStatus;
        message: string;
        type: ExceptionType;
    };
    static readonly CONFLICT: {
        status: HttpStatus;
        message: string;
        type: ExceptionType;
    };
    static readonly INTERNAL: {
        status: HttpStatus;
        message: string;
        type: ExceptionType;
    };
}
export declare class HttpExceptionFilter implements ExceptionFilter {
    private readonly LOGGER;
    catch(exception: unknown, host: ArgumentsHost): void;
    private isZodError;
    private formatZodIssues;
    private getExceptionConstructorName;
    private extractMessage;
    private isAxiosError;
    private extractAxiosErrorDetails;
    private formatStackTrace;
}
