"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.NotificationModule = void 0;
const common_1 = require("@nestjs/common");
const notification_controller_1 = require("../../controllers/notification/notification.controller");
const email_service_impl_1 = require("../../service/email-service-impl/email-service-impl");
const mailer_1 = require("@nestjs-modules/mailer");
const config_1 = require("@nestjs/config");
const drizzle_1 = require("../../drizzle");
const service_1 = require("../../service");
const user_device_module_1 = require("../user-device/user-device.module");
const notification_record_module_1 = require("../notification-record/notification-record.module");
let NotificationModule = class NotificationModule {
};
exports.NotificationModule = NotificationModule;
exports.NotificationModule = NotificationModule = __decorate([
    (0, common_1.Module)({
        controllers: [notification_controller_1.NotificationController],
        imports: [
            config_1.ConfigModule,
            drizzle_1.DrizzleModule,
            user_device_module_1.UserDeviceModule,
            notification_record_module_1.NotificationRecordModule,
            mailer_1.MailerModule.forRootAsync({
                imports: [config_1.ConfigModule],
                useFactory: async (configService) => ({
                    transport: {
                        service: 'gmail',
                        port: 587,
                        secure: false,
                        logger: true,
                        debug: true,
                        secureConnection: false,
                        auth: {
                            user: configService.get('MAIL_USER'),
                            pass: configService.get('MAIL_PASS'),
                        },
                        tls: {
                            rejectUnauthorized: false
                        }
                    },
                    defaults: {
                        from: `MySCAR Bienvenido <${configService.get('MAIL_FROM')}>`,
                    },
                }),
                inject: [config_1.ConfigService],
            }),
        ],
        providers: [
            {
                provide: 'EmailService',
                useClass: email_service_impl_1.EmailServiceImpl,
            },
            {
                provide: 'FirebaseService',
                useClass: service_1.FirebaseImplService,
            },
        ],
        exports: [
            'EmailService',
            'FirebaseService',
        ],
    })
], NotificationModule);
//# sourceMappingURL=notification.module.js.map