import { GeoRepository } from 'src/framework/application/repository/geo-repository/geo-repository.interface';
import { AdministrativeDivision, Country } from 'src/framework/domain';
import { DBConfigService } from '../../drizzle';
import { Subdivision } from 'src/framework/domain/entities/subdivision.entity';
export declare class GeoRepositoryImpl implements GeoRepository {
    private readonly db;
    private readonly LOGGER;
    constructor(db: DBConfigService);
    findCountries(): Promise<Country[]>;
    findCountryById(id: number): Promise<Country | null>;
    findSubdivisionsByCountryCode(countryCode: string): Promise<Subdivision[]>;
    findAdmdivisionsBySubdivisionCode(subdivisionCode: number): Promise<AdministrativeDivision[]>;
    findAdmdivisionsByCountry(prefixCode: string): Promise<AdministrativeDivision[]>;
}
