"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var TypeMasterRepositoryImpl_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TypeMasterRepositoryImpl = void 0;
const common_1 = require("@nestjs/common");
const domain_1 = require("../../../domain");
const drizzle_1 = require("../../drizzle");
const schema = require("../../drizzle/migrations/schema");
const drizzle_orm_1 = require("drizzle-orm");
const enum_definition_1 = require("../../../domain/enum/enum.definition");
const app_exception_logger_1 = require("../../definition/logger/app.exception.logger");
let TypeMasterRepositoryImpl = TypeMasterRepositoryImpl_1 = class TypeMasterRepositoryImpl {
    constructor(db) {
        this.db = db;
        this.LOGGER = new app_exception_logger_1.PrimeLogger(TypeMasterRepositoryImpl_1.name);
    }
    async findByDiscriminator(discriminator, tx) {
        this.LOGGER.log(`findByDiscriminator - discriminator: ${discriminator}`);
        const discriminatorOBJ = enum_definition_1.TypeMasterDiscriminatorEnum[discriminator];
        return await (tx || this.db.conn)
            .select({
            id: schema.typeMasterTable.id,
            name: schema.typeMasterTable.name,
            shortName: schema.typeMasterTable.shortName,
            discriminator: schema.typeMasterTable.discriminator,
            order: schema.typeMasterTable.order,
        })
            .from(schema.typeMasterTable)
            .where((0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(schema.typeMasterTable.active, true), (0, drizzle_orm_1.eq)(schema.typeMasterTable.discriminator, discriminatorOBJ)))
            .orderBy(schema.typeMasterTable.order)
            .then((rows) => {
            if (rows.length === 0) {
                return null;
            }
            return new domain_1.TypeMaster(rows[0].id, rows[0].name, rows[0].shortName, rows[0].discriminator, rows[0].order);
        });
    }
    async findById(id, tx) {
        this.LOGGER.log(`findById - id: ${id}`);
        return await (tx || this.db.conn)
            .select({
            id: schema.typeMasterTable.id,
            name: schema.typeMasterTable.name,
            shortName: schema.typeMasterTable.shortName,
            discriminator: schema.typeMasterTable.discriminator,
            order: schema.typeMasterTable.order,
        })
            .from(schema.typeMasterTable)
            .where((0, drizzle_orm_1.eq)(schema.typeMasterTable.id, id))
            .then((rows) => {
            if (rows.length === 0) {
                return null;
            }
            return new domain_1.TypeMaster(rows[0].id, rows[0].name, rows[0].shortName, rows[0].discriminator, rows[0].order);
        });
    }
    async findByShortName(shortName, tx) {
        this.LOGGER.log(`findByShortName - shortName: ${shortName}`);
        return await (tx || this.db.conn)
            .select({
            id: schema.typeMasterTable.id,
            name: schema.typeMasterTable.name,
            shortName: schema.typeMasterTable.shortName,
            discriminator: schema.typeMasterTable.discriminator,
            order: schema.typeMasterTable.order,
        })
            .from(schema.typeMasterTable)
            .where((0, drizzle_orm_1.eq)(schema.typeMasterTable.shortName, shortName))
            .then((rows) => {
            if (rows.length === 0) {
                return null;
            }
            return new domain_1.TypeMaster(rows[0].id, rows[0].name, rows[0].shortName, rows[0].discriminator, rows[0].order);
        });
    }
    async save(typeMaster, tx) {
        this.LOGGER.log(`save - typeMaster: ${JSON.stringify(typeMaster)}`);
        const validateTypeMaster = schema.typeMasterTableInsertSchema.parse(typeMaster);
        const typeMasterId = await (tx || this.db.conn)
            .insert(schema.typeMasterTable)
            .values(validateTypeMaster)
            .$returningId()
            .then((rows) => {
            return rows[0].id;
        });
        return await this.findById(typeMasterId, tx).then((typeMaster) => {
            if (typeMaster) {
                return typeMaster;
            }
            throw new Error('TypeMaster not found');
        });
    }
};
exports.TypeMasterRepositoryImpl = TypeMasterRepositoryImpl;
exports.TypeMasterRepositoryImpl = TypeMasterRepositoryImpl = TypeMasterRepositoryImpl_1 = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [drizzle_1.DBConfigService])
], TypeMasterRepositoryImpl);
//# sourceMappingURL=type-master-repository-impl.js.map