import { UserRoleRepository } from 'src/framework/application';
import { Role, UserPage, UserRoleTO } from 'src/framework/domain';
import { DBConfigService } from 'src/framework/infrastructure/drizzle';
export declare class UserRolRepositoryImpl implements UserRoleRepository {
    private readonly db;
    private readonly LOGGER;
    constructor(db: DBConfigService);
    getUserRoles(userId: number): Promise<Role[]>;
    getAllPaginated(page: number, pageSize: number, profileId: number): Promise<UserPage[]>;
    getAdminUserIds(): Promise<number[]>;
    updateRoles(params: UserRoleTO, profileId: number): Promise<boolean | undefined>;
    getRolesByUserId(userId: number): Promise<string[]>;
    save(userId: number, roleId: number): Promise<boolean>;
}
