"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var UserRolRepositoryImpl_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserRolRepositoryImpl = void 0;
const common_1 = require("@nestjs/common");
const drizzle_orm_1 = require("drizzle-orm");
const domain_1 = require("../../../domain");
const drizzle_1 = require("../../drizzle");
const schema = require("../../drizzle/migrations/schema");
const definition_1 = require("../../definition");
const allow_roles_decorator_1 = require("../../decorators/allow-profiles/allow-roles.decorator");
let UserRolRepositoryImpl = UserRolRepositoryImpl_1 = class UserRolRepositoryImpl {
    constructor(db) {
        this.db = db;
        this.LOGGER = new definition_1.PrimeLogger(UserRolRepositoryImpl_1.name);
    }
    async getUserRoles(userId) {
        this.LOGGER.log(`Finding roles for user id: ${userId}`);
        return await this.db.conn
            .select({
            id: schema.roleTable.id,
            name: schema.roleTable.name,
            shortName: schema.roleTable.shortName,
        })
            .from(schema.roleTable)
            .innerJoin(schema.userRoleTable, (0, drizzle_orm_1.eq)(schema.roleTable.id, schema.userRoleTable.roleId))
            .where((0, drizzle_orm_1.eq)(schema.userRoleTable.userId, userId))
            .then((rows) => {
            this.LOGGER.log(`Found ${rows.length} profiles for user id: ${userId}`);
            return rows.map((row) => new domain_1.Role(row.id, row.name, row.shortName));
        });
    }
    async getAllPaginated(page, pageSize, profileId) {
        const offset = (page - 1) * pageSize;
        this.LOGGER.log(`findAll user profile offset: ${offset} page: ${page}, pageSize: ${pageSize}, profileId: ${profileId}`);
        const selectFields = {
            id: schema.userTable.id,
            name: schema.userTable.name,
            lastName: schema.userTable.lastName,
            email: schema.userTable.email,
        };
        const whereSentence = (0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(schema.userTable.active, true), (0, drizzle_orm_1.eq)(schema.roleTable.id, profileId));
        const query = this.db.conn
            .select(selectFields)
            .from(schema.userRoleTable)
            .leftJoin(schema.userTable, (0, drizzle_orm_1.eq)(schema.userTable.id, schema.userRoleTable.userId)).leftJoin(schema.roleTable, (0, drizzle_orm_1.eq)(schema.roleTable.id, schema.userRoleTable.roleId))
            .where(whereSentence)
            .limit(Number(pageSize))
            .offset(offset);
        const rows = await query;
        if (rows.length === 0) {
            return [];
        }
        return rows.map((row) => {
            const record = new domain_1.UserPage();
            record.id = row.id;
            record.name = row.name;
            record.lastName = row.lastName;
            record.email = row.email;
            return record;
        });
    }
    async getAdminUserIds() {
        this.LOGGER.log('Getting admin user ids');
        try {
            const adminProfiles = await this.db.conn
                .select({
                userId: schema.userRoleTable.userId
            })
                .from(schema.userRoleTable)
                .innerJoin(schema.roleTable, (0, drizzle_orm_1.eq)(schema.userRoleTable.roleId, schema.roleTable.id))
                .where((0, drizzle_orm_1.eq)(schema.roleTable.shortName, allow_roles_decorator_1.RoleShortNameEnum.ADMIN)).execute();
            return adminProfiles.map((profile) => profile.userId);
        }
        catch (error) {
            throw new Error(error);
        }
    }
    async updateRoles(params, profileId) {
        this.LOGGER.log(`Updating profiles for user id: ${params}`);
        if (params.isAdded) {
            this.LOGGER.log(`Adding profile ${profileId} to user ${params.userId}`);
            return await this.save(params.userId, profileId);
        }
        else {
            this.LOGGER.log(`Removing profile ${profileId} from user ${params.userId}`);
            await (this.db.conn)
                .delete(schema.userRoleTable)
                .where((0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(schema.userRoleTable.userId, params.userId), (0, drizzle_orm_1.eq)(schema.userRoleTable.roleId, profileId)))
                .execute();
        }
    }
    async getRolesByUserId(userId) {
        this.LOGGER.log(`Getting roles for user id: ${userId}`);
        const profiles = await this.db.conn
            .select({
            shortName: schema.roleTable.shortName
        })
            .from(schema.userRoleTable)
            .innerJoin(schema.roleTable, (0, drizzle_orm_1.eq)(schema.userRoleTable.roleId, schema.roleTable.id))
            .where((0, drizzle_orm_1.eq)(schema.userRoleTable.userId, userId))
            .execute();
        return profiles.map((profile) => profile.shortName);
    }
    async save(userId, roleId) {
        this.LOGGER.log(`Saving user role with userId: ${userId}, roleId: ${roleId}`);
        try {
            await this.db.conn
                .insert(schema.userRoleTable)
                .values({ userId, roleId });
            return true;
        }
        catch (error) {
            throw new Error(error);
        }
    }
};
exports.UserRolRepositoryImpl = UserRolRepositoryImpl;
exports.UserRolRepositoryImpl = UserRolRepositoryImpl = UserRolRepositoryImpl_1 = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [drizzle_1.DBConfigService])
], UserRolRepositoryImpl);
//# sourceMappingURL=user-rol-repository-impl.js.map