"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var FirebaseImplService_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FirebaseImplService = void 0;
const common_1 = require("@nestjs/common");
const admin = require("firebase-admin");
const app_exception_logger_1 = require("../../definition/logger/app.exception.logger");
const util_1 = require("../../../../licitaapp/domain/util");
let FirebaseImplService = FirebaseImplService_1 = class FirebaseImplService {
    constructor(notificationRecordService, userDeviceService, emailService) {
        this.notificationRecordService = notificationRecordService;
        this.userDeviceService = userDeviceService;
        this.emailService = emailService;
        this.LOGGER = new app_exception_logger_1.PrimeLogger(FirebaseImplService_1.name);
        if (admin.apps.length === 0) {
            admin.initializeApp({
                credential: admin.credential.applicationDefault(),
            });
        }
        this.messaging = admin.messaging();
        this.auth = admin.auth();
    }
    async verifyIdToken(idToken) {
        try {
            const decodedToken = await this.auth.verifyIdToken(idToken);
            this.LOGGER.log(`Token verificado: ${JSON.stringify(decodedToken)}`);
            return decodedToken;
        }
        catch (error) {
            this.LOGGER.error(`Error verificando el token: ${error.message}`);
            throw error;
        }
    }
    stringToNumberHash(str) {
        let hash = 0;
        for (let i = 0; i < str.length; i++) {
            hash = (hash * 31 + str.charCodeAt(i)) % 1000000007;
        }
        return hash;
    }
    async sendPushNotification(tokens, title, body, data) {
        if (tokens.length === 0) {
            this.LOGGER.warn('No tokens to send message');
            return;
        }
        const currentDate = new Date();
        const idMessage = this.stringToNumberHash(title + currentDate.getDay());
        data = { ...data, id_message: idMessage.toString() };
        const messages = tokens.map((token) => ({
            notification: {
                title,
                body,
            },
            data,
            token,
        }));
        try {
            const response = await this.messaging.sendEach(messages);
            for (const res of response.responses) {
                if (res.success) {
                    this.LOGGER.debug(`Successfully sent message: ${JSON.stringify(response)}`);
                }
                else {
                    const index = response.responses.indexOf(res);
                    const token = tokens[index];
                    const jsonTxt = JSON.stringify(res);
                    this.LOGGER.error(`Error sending message to token ${token} (index ${index}): ${jsonTxt}`);
                    if (jsonTxt.includes('messaging/registration-token-not-registered')) {
                        this.userDeviceService.erraseUserDevice(token);
                    }
                }
            }
            return response;
        }
        catch (error) {
            this.LOGGER.error(`Error sending message: ${JSON.stringify(error)}`);
            throw error;
        }
    }
    async deleteUserFromFirebase(uid) {
        this.LOGGER.log(`Eliminando usuario con UID ${uid} de Firebase`);
        try {
            await this.auth.deleteUser(uid);
            this.LOGGER.log(`Usuario con UID ${uid} eliminado de Firebase`);
        }
        catch (error) {
            this.LOGGER.error(`Error eliminando el usuario con UID ${uid}`, error);
            throw error;
        }
    }
    async groupNotifications(userId) {
        this.LOGGER.log(`groupNotifications - userId: ${userId}`);
        const tokens = await this.userDeviceService.findTokensByUserId(userId);
        if (tokens.length === 0) {
            this.LOGGER.log(`groupNotifications - no tokens for user: ${userId}`);
            return;
        }
        const listRecordsToNotify = await this.notificationRecordService.getActiveNotificationRecords(userId);
        const counts = listRecordsToNotify.reduce((acc, record) => {
            if (record.title.includes('Encontradas por Ubicación'))
                acc.countForSubdivision++;
            else if (record.title.includes('favorita por cerrar'))
                acc.countForFavoriteToClose++;
            else if (record.monthFilterTender)
                acc.countForMonth++;
            return acc;
        }, { countForSubdivision: 0, countForFavoriteToClose: 0, countForMonth: 0 });
        this.LOGGER.log(`groupNotifications - tokens: ${tokens.length} for user: ${userId} countForFavoriteToClose: ${counts.countForFavoriteToClose} countForSubdivision: ${counts.countForSubdivision} countForMonth: ${counts.countForMonth}`);
        const notifications = [
            { condition: counts.countForSubdivision > 0, title: 'Encontradas por Ubicación', body: `Licitaciones encontradas para tus regiones de interés`, type_message: 'general_tender_alert' },
            { condition: counts.countForFavoriteToClose > 0, title: 'Favoritos por cerrarse', body: `Licitaciones favoritas por cerrarse encontradas ${counts.countForFavoriteToClose}`, type_message: 'favorite_tender_alert' },
            { condition: counts.countForMonth > 0, title: 'Encontradas por Rubros', body: 'Licitaciones encontradas por palabras claves', type_message: 'history_tender' }
        ];
        try {
            for (const notification of notifications) {
                if (notification.condition) {
                    await this.sendPushNotification(tokens, notification.title, notification.body, { type_message: notification.type_message });
                }
            }
        }
        catch (error) {
            this.LOGGER.error(`groupNotifications try to send to users - Error: ${error}`);
            throw error;
        }
        this.notificationRecordService.logicalRemoveBYListId(listRecordsToNotify.map(record => record.id));
        this.notifyToAdminUsers();
    }
    async notifyToAdminUsers() {
        const tokensUser = await this.userDeviceService.getAdminUserDeviceTokens();
        if (tokensUser.length === 0) {
            this.LOGGER.log(`notifyToAdminUsers - no tokens for admin`);
            return;
        }
        const listRecordsToNotify = await this.notificationRecordService.getActiveNotificationRecords(0, true);
        this.LOGGER.log(`notifyToAdminUsers - listRecordsToNotify: ${listRecordsToNotify.length}`);
        if (listRecordsToNotify.length > 0) {
            try {
                if (listRecordsToNotify.length == 1) {
                    await this.sendPushNotification(tokensUser, 'Administrador', `El usuario  ha solicitado apoyo por una licitación.`, { type_message: 'tender_new' });
                }
                else {
                    await this.sendPushNotification(tokensUser, 'Administrador', `Existen ${listRecordsToNotify.length} solicitudes por responder.`, { type_message: 'tender_new' });
                }
                this.notificationRecordService.logicalRemoveBYListId(listRecordsToNotify.map(record => record.id));
            }
            catch (error) {
                this.LOGGER.error(`notifyToAdminUsers - Error: ${error}`);
                throw error;
            }
        }
    }
    async sendDailyEmailSumary(applicationLogId) {
        this.LOGGER.log(`sendDailyEmailSumary - START - applicationLogId: ${applicationLogId}`);
        const sendToNotify = await this.notificationRecordService.getUserNotificationRecordsActive();
        const messageTxt = `sendDailyEmailSumary - applicationLogId: ${applicationLogId} - sendToNotify size: ${sendToNotify.length}`;
        const groupedNotifications = sendToNotify.reduce((acc, notification) => {
            if (!acc[notification.userId]) {
                acc[notification.userId] = [];
            }
            acc[notification.userId].push(notification);
            return acc;
        }, {});
        const systemHour = util_1.TenderUtil.getSystemDateDDMMYYYY();
        const dayOfWeek = systemHour.toLocaleString('es-CL', { weekday: 'long' });
        for (const userId in groupedNotifications) {
            messageTxt.concat(`. Processing userId: ${userId}`);
            const notifications = groupedNotifications[userId];
            const totalAmountWords = notifications.reduce((sum, notification) => sum + (notification.amountWords || 0), 0);
            const totalGeo = notifications.reduce((sum, notification) => sum + (notification.amountGeo || 0), 0);
            this.LOGGER.log(`Processing notifications email line for user: ${userId} - totalAmountWords: ${totalAmountWords} - totalGeo: ${totalGeo}`);
            await this.sendNewsEmail(notifications[0].userEmail, `${dayOfWeek} ${systemHour.toLocaleDateString('es-CL', { day: '2-digit', month: '2-digit', year: 'numeric' })} `, totalAmountWords, totalGeo);
            this.notificationRecordService.markNotificationEmailAsSent(notifications.map(notification => notification.id));
        }
        return messageTxt;
    }
    async sendNewsEmail(email, dayOfweekLabel, amountWordsTender = 0, amountGeoTenders = 0) {
        this.LOGGER.log(`Sending news email to: ${email}`);
        await this.emailService.sendNewsEmail(email, 'LICITAAPP Resumen diario actividades', dayOfweekLabel, amountWordsTender, amountGeoTenders);
    }
    async sendEmailSumaryToAdmin(applicationLogId, userService) {
        const userIdsAdmin = await userService.findEmailsAdmin();
        var messageTxt = `ApplicationLogId: ${applicationLogId} - Administradores activos: ${userIdsAdmin.length}`;
        this.LOGGER.log(`sendEmailSumaryToAdmin - userIdsAdmin: ${userIdsAdmin.length}`);
        const sendToNotify = await this.notificationRecordService.getAdminNotification();
        this.LOGGER.log(`sendEmailSumaryToAdmin - sendToNotify: ${sendToNotify.length}`);
        if (sendToNotify.length > 0) {
            for (const email of userIdsAdmin) {
                messageTxt = messageTxt.concat(` - Enviando email a: ${email}`);
                await this.emailService.sendAdminEmail(email, 'LICITAAPP Administrador', `Administrador, existen ${sendToNotify.length} solicitudes por responder.`);
            }
            messageTxt = messageTxt.concat(` - Enviando notificaciones: ${sendToNotify.length}`);
            this.notificationRecordService.markNotificationEmailAsSent(sendToNotify.map(notification => notification.id));
            messageTxt = messageTxt.concat(` - Notificacion finalizada.`);
        }
        return messageTxt;
    }
};
exports.FirebaseImplService = FirebaseImplService;
exports.FirebaseImplService = FirebaseImplService = FirebaseImplService_1 = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, common_1.Inject)('NotificationRecordService')),
    __param(1, (0, common_1.Inject)('UserDeviceService')),
    __param(2, (0, common_1.Inject)('EmailService')),
    __metadata("design:paramtypes", [Object, Object, Object])
], FirebaseImplService);
//# sourceMappingURL=firebase-impl.service.js.map