import { NotificationRecordService } from 'src/framework/application/service/notification-record-service/notification-record-service.interface';
import { NotificationRecord, InsertNotificationRecord, UpdateNotificationRecord } from 'src/framework/domain';
import { TxType } from '../../drizzle';
import { NotificationRecordRepository } from 'src/framework/application/repository/notification-record-repository/notification-record-repository.interface';
export declare class NotificationRecordServiceImpl implements NotificationRecordService {
    private readonly notificationRecordRepository;
    private readonly LOGGER;
    constructor(notificationRecordRepository: NotificationRecordRepository);
    erraseNotificationRecordsByTender(tenderIds: number[], tx?: TxType): Promise<void>;
    getNotificationRecordsPaginated(userId: number, page: number, pageSize: number): Promise<NotificationRecord[]>;
    getUserNotificationRecordsActive(): Promise<NotificationRecord[]>;
    getAdminNotification(): Promise<NotificationRecord[]>;
    saveAll(notificationRecords: InsertNotificationRecord[], tx?: TxType): Promise<void>;
    updateNotification(notificationRecordId: number, notificationRecord: UpdateNotificationRecord, tx?: TxType): Promise<void>;
    getActiveNotificationRecords(userId: number, isAdmin?: boolean): Promise<NotificationRecord[]>;
    logicalRemoveBYListId(notificationRecordIds: number[], tx?: TxType): Promise<void>;
    markNotificationEmailAsSent(notificationRecordId: number[], tx?: TxType): Promise<void>;
}
