import { RoleService, UserRoleRepository, UserRoleService } from 'src/framework/application';
import { Role, UserPage, UserRoleTO } from 'src/framework/domain';
import { RoleShortNameEnum } from '../../decorators/allow-profiles/allow-roles.decorator';
export declare class UserRoleImplService implements UserRoleService {
    private readonly userRoleRepository;
    private readonly roleService;
    private readonly LOGGER;
    constructor(userRoleRepository: UserRoleRepository, roleService: RoleService);
    getUserRoles(userId: number): Promise<Role[]>;
    getAdminUserIds(): Promise<number[]>;
    getAllPaginated(page: number, pageSize: number, profile?: RoleShortNameEnum): Promise<UserPage[]>;
    updateProfiles(params: UserRoleTO, profileId: number): Promise<void>;
    getRolesByUserId(userId: number): Promise<string[]>;
    createUserRole(userId: number, roleId: number): Promise<boolean>;
}
