import { User } from "src/framework";
import { DashboardTO, HistoryTender, HistoryTenderDetail, InsertTender, ParamsNotificationTO, Tender } from "src/licitaapp/domain";
import { ApplicationTypeEnum } from "src/licitaapp/domain/enum/enum.definition";
export interface TenderService {
    addTenderByCodeToCompany(code: string, companyId: number): Promise<string>;
    checkCloseDate(applicationLogId: number): Promise<string>;
    checkMetadataKeywords(applicationLogId: number): Promise<string>;
    checkNewTendersUserCompany(applicationLogId: number): Promise<string>;
    checkTenderFavoritesToClose(applicationLogId: number): Promise<string>;
    checkTenderWithCloseDate(applicationLogId: number): Promise<string>;
    checkTenderSubdivision(applicationLogId: number): Promise<string>;
    createDashboardCompany(companyId: number, userId: number): Promise<void>;
    fetchRazorMetadata(textToEval: string): Promise<any>;
    generateInfoDashboard(user: User, companyId: number): Promise<DashboardTO>;
    getListTenderHistory(userId: number): Promise<HistoryTender[]>;
    getPaginatedHistoryTenders(userId: number, page: number, pageSize: number): Promise<HistoryTenderDetail[]>;
    getPaginatedTenders(userId: number, companyId: number, page: number, pageSize: number, searchType: string, subdivisionId: number, monthRequest: string): Promise<Tender[]>;
    getTenderByCode(code: string, userId?: number): Promise<Tender | undefined>;
    logicalRemoveCompanyTenderUser(userId: number, companyId: number, tenderId: number): Promise<void>;
    recalculteTender(applicationLogId: number): Promise<string>;
    reviewTendersInfo(action: ApplicationTypeEnum): Promise<void>;
    reviewTenderStatus(applicationLogId: number): Promise<string>;
    reviewTenderWihoutMetadata(applicationLogId: number): Promise<string>;
    searchTendersDB(params: ParamsNotificationTO, waitMinutes?: boolean): Promise<String>;
    searchTenderToUserCompanyWithSubdivision(companyId: number, userId: number): Promise<void>;
    tenderTaskEvery5Minutes(): Promise<void>;
    tenderTaskPerMinutes(): Promise<void>;
    tenderTaskBy2Hour(): Promise<void>;
    tenderTaskPerDay(): Promise<void>;
    tenderTaskByHour(): Promise<void>;
    updateFavoriteUserCompanytender(userId: number, companyId: number, tenderId: number, isFavorite: boolean): Promise<void>;
    upsert(tender: InsertTender): Promise<number>;
    erraseOldTenders(): Promise<string>;
}
