"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.HistoryTenderDetail = exports.RequestTender = exports.UpdateTender = exports.Tender = exports.InsertTender = void 0;
const swagger_1 = require("@nestjs/swagger");
class Tender {
    constructor(id, code, name, description, details, createdAt, updatedAt, closeDate, isFavorite, subdivisionId, source, labelCloseTender, metadata, matchResult) {
        this.code = code;
        this.name = name;
        this.closeDate = closeDate;
        this.description = description;
        this.id = id;
        this.details = details;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.subdivisionId = subdivisionId;
        this.source = source;
        this.labelCloseTender = labelCloseTender;
        this.metadata = metadata;
        this.matchResult = matchResult;
        this.isFavorite = isFavorite;
    }
}
exports.Tender = Tender;
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Tender id',
        example: 1,
    }),
    __metadata("design:type", Number)
], Tender.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Tender code',
        example: '1111-111-A111',
    }),
    __metadata("design:type", String)
], Tender.prototype, "code", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Tender name',
        example: 'School supplies',
    }),
    __metadata("design:type", String)
], Tender.prototype, "name", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Tender description',
        example: 'School supplies for the next school year',
    }),
    __metadata("design:type", String)
], Tender.prototype, "description", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Tender details',
    }),
    __metadata("design:type", Object)
], Tender.prototype, "details", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Price',
        example: '15M CLP',
    }),
    __metadata("design:type", String)
], Tender.prototype, "labelAmount", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Type of money',
        example: 'CLP',
    }),
    __metadata("design:type", String)
], Tender.prototype, "typeOfMoney", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Last updated record',
        example: '1 minute ago',
    }),
    __metadata("design:type", String)
], Tender.prototype, "labelLastUpdated", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Creation date',
        example: '1991-01-01T00:00:00.000Z',
        required: false,
    }),
    __metadata("design:type", Date)
], Tender.prototype, "createdAt", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Tender isFavorite',
        example: true,
    }),
    __metadata("design:type", Boolean)
], Tender.prototype, "isFavorite", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Last update date',
        example: '1991-01-01T00:00:00.000Z',
        required: false,
    }),
    __metadata("design:type", Object)
], Tender.prototype, "updatedAt", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Close date',
        example: '1991-01-01T00:00:00.000Z',
        required: false,
    }),
    __metadata("design:type", Object)
], Tender.prototype, "closeDate", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Subdivision id',
        example: '19',
        required: false,
    }),
    __metadata("design:type", Object)
], Tender.prototype, "subdivisionId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Source',
        example: 'GEO',
        required: false,
    }),
    __metadata("design:type", String)
], Tender.prototype, "source", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Close tender label',
        example: '12 h',
        required: false,
    }),
    __metadata("design:type", String)
], Tender.prototype, "labelCloseTender", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Metadata',
        required: false,
    }),
    __metadata("design:type", Object)
], Tender.prototype, "metadata", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Match result',
        required: false,
    }),
    __metadata("design:type", Object)
], Tender.prototype, "matchResult", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Tender is errased',
        example: true,
        required: false,
    }),
    __metadata("design:type", Boolean)
], Tender.prototype, "isErrased", void 0);
class InsertTender extends (0, swagger_1.OmitType)(Tender, ['id', 'isErrased', 'labelAmount', 'typeOfMoney', 'labelLastUpdated', 'createdAt', 'updatedAt', 'labelCloseTender', 'matchResult']) {
}
exports.InsertTender = InsertTender;
class RequestTender extends (0, swagger_1.OmitType)(Tender, ['details', 'createdAt', 'updatedAt']) {
}
exports.RequestTender = RequestTender;
class UpdateTender extends (0, swagger_1.PartialType)(Tender) {
}
exports.UpdateTender = UpdateTender;
class HistoryTenderDetail extends (0, swagger_1.OmitType)(Tender, ['subdivisionId', 'metadata', 'source', 'matchResult', 'closeDate', 'details', 'isFavorite', 'createdAt', 'updatedAt']) {
}
exports.HistoryTenderDetail = HistoryTenderDetail;
//# sourceMappingURL=tender.entity.js.map