"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var CompanyController_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CompanyController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const framework_1 = require("../../../../framework");
const allow_roles_decorator_1 = require("../../../../framework/infrastructure/decorators/allow-profiles/allow-roles.decorator");
const api_default_responses_decorator_1 = require("../../../../framework/infrastructure/decorators/api-default-responses/api-default-responses.decorator");
const prime_user_decorator_1 = require("../../../../framework/infrastructure/decorators/prime-user/prime-user.decorator");
const domain_1 = require("../../../domain");
const company_user_to_1 = require("../../../domain/dto/company.user.to");
let CompanyController = CompanyController_1 = class CompanyController {
    constructor(companyService, userCompanyService, tenderService) {
        this.companyService = companyService;
        this.userCompanyService = userCompanyService;
        this.tenderService = tenderService;
        this.LOGGER = new framework_1.PrimeLogger(CompanyController_1.name);
    }
    async companiesByUserId(user) {
        this.LOGGER.warn(`Finding if user: ${user.id} have any companies`);
        return await this.userCompanyService.findCompaniesByUserId(user.id);
    }
    async activeCheckTender(id) {
        this.LOGGER.warn(`ActiveCheckTender company ${id}`);
        this.companyService.updateCheckTenders(id, true);
        return 'true';
    }
    async update(user, id, companyData) {
        this.LOGGER.warn(`Updating company ${id}`);
        const outputObj = await this.companyService.updateCompany(id, user.id, companyData);
        this.tenderService.createDashboardCompany(id, user.id);
        return outputObj;
    }
    async findById(id) {
        this.LOGGER.warn(`findById id ${id}`);
        return this.companyService.findByIdWithFetch(id);
    }
    async paginationByUser(user, page, pageSize) {
        this.LOGGER.warn(`paginationByUser user ${user.id} page ${page} pageSize ${pageSize}`);
        return await this.userCompanyService.paginationByUser(user.id, page, pageSize);
    }
    async findByUserId(user) {
        this.LOGGER.warn(`findByUserId user ${user.id}`);
        return await this.userCompanyService.findCompaniesByUserId(user.id);
    }
    async logicalRemove(user, companyId, userId) {
        this.LOGGER.warn(`delete companyId ${companyId} user ${userId}`);
        await this.userCompanyService.deleteByUserCompany(userId == 0 ? user.id : userId, companyId);
        return 'true';
    }
    async paginationCompanyAdmin(page, pageSize) {
        this.LOGGER.warn(`paginationByCompanyAdmin page ${page} pageSize ${pageSize}`);
        return await this.companyService.paginationByCompanyAdmin(page, pageSize);
    }
};
exports.CompanyController = CompanyController;
__decorate([
    (0, common_1.Get)('companies-by-user'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER),
    (0, swagger_1.ApiOkResponse)({ type: [domain_1.Company] }),
    __param(0, (0, prime_user_decorator_1.PrimeUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [framework_1.User]),
    __metadata("design:returntype", Promise)
], CompanyController.prototype, "companiesByUserId", null);
__decorate([
    (0, common_1.Put)('check-tender/:id'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, swagger_1.ApiOkResponse)({ type: () => domain_1.CompanyFullTO }),
    (0, swagger_1.ApiParam)({ name: 'id', type: 'number' }),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", Promise)
], CompanyController.prototype, "activeCheckTender", null);
__decorate([
    (0, common_1.Put)(':id'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, swagger_1.ApiOkResponse)({ type: () => domain_1.CompanyFullTO }),
    (0, swagger_1.ApiParam)({ name: 'id', type: 'number' }),
    (0, swagger_1.ApiBody)({ type: domain_1.CompanyRegisterTO }),
    __param(0, (0, prime_user_decorator_1.PrimeUser)()),
    __param(1, (0, common_1.Param)('id')),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [framework_1.User, Number, domain_1.CompanyRegisterTO]),
    __metadata("design:returntype", Promise)
], CompanyController.prototype, "update", null);
__decorate([
    (0, common_1.Get)(':id'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER),
    (0, swagger_1.ApiParam)({ name: 'id', type: 'number' }),
    (0, swagger_1.ApiOkResponse)({ type: () => domain_1.CompanyFullTO }),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", Promise)
], CompanyController.prototype, "findById", null);
__decorate([
    (0, common_1.Get)(':page/:pageSize'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER),
    (0, swagger_1.ApiOkResponse)({ type: [domain_1.Company] }),
    (0, swagger_1.ApiParam)({ name: 'page', type: 'number' }),
    (0, swagger_1.ApiParam)({ name: 'pageSize', type: 'number' }),
    __param(0, (0, prime_user_decorator_1.PrimeUser)()),
    __param(1, (0, common_1.Param)('page')),
    __param(2, (0, common_1.Param)('pageSize')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [framework_1.User, Number, Number]),
    __metadata("design:returntype", Promise)
], CompanyController.prototype, "paginationByUser", null);
__decorate([
    (0, common_1.Get)(),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER),
    (0, swagger_1.ApiOkResponse)({ type: [domain_1.Company] }),
    __param(0, (0, prime_user_decorator_1.PrimeUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [framework_1.User]),
    __metadata("design:returntype", Promise)
], CompanyController.prototype, "findByUserId", null);
__decorate([
    (0, common_1.Delete)('relation/:companyId/:userId'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, swagger_1.ApiOkResponse)({ type: String }),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER),
    __param(0, (0, prime_user_decorator_1.PrimeUser)()),
    __param(1, (0, common_1.Param)('companyId')),
    __param(2, (0, common_1.Param)('userId')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [framework_1.User, Number, Number]),
    __metadata("design:returntype", Promise)
], CompanyController.prototype, "logicalRemove", null);
__decorate([
    (0, common_1.Get)('paginated-admin/:page/:pageSize'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER, allow_roles_decorator_1.RoleShortNameEnum.ADMIN),
    (0, swagger_1.ApiOkResponse)({ type: [company_user_to_1.CompanyUserTO] }),
    (0, swagger_1.ApiParam)({ name: 'page', type: 'number' }),
    (0, swagger_1.ApiParam)({ name: 'pageSize', type: 'number' }),
    __param(0, (0, common_1.Param)('page')),
    __param(1, (0, common_1.Param)('pageSize')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], CompanyController.prototype, "paginationCompanyAdmin", null);
exports.CompanyController = CompanyController = CompanyController_1 = __decorate([
    (0, swagger_1.ApiTags)('company'),
    (0, common_1.Controller)('company'),
    __param(0, (0, common_1.Inject)('CompanyService')),
    __param(1, (0, common_1.Inject)('UserCompanyService')),
    __param(2, (0, common_1.Inject)('TenderService')),
    __metadata("design:paramtypes", [Object, Object, Object])
], CompanyController);
//# sourceMappingURL=company.controller.js.map