"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var KeywordController_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KeywordController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const framework_1 = require("../../../../framework");
const allow_roles_decorator_1 = require("../../../../framework/infrastructure/decorators/allow-profiles/allow-roles.decorator");
const api_default_responses_decorator_1 = require("../../../../framework/infrastructure/decorators/api-default-responses/api-default-responses.decorator");
const prime_user_decorator_1 = require("../../../../framework/infrastructure/decorators/prime-user/prime-user.decorator");
const domain_1 = require("../../../domain");
let KeywordController = KeywordController_1 = class KeywordController {
    constructor(keywordService, companyService) {
        this.keywordService = keywordService;
        this.companyService = companyService;
        this.LOGGER = new framework_1.PrimeLogger(KeywordController_1.name);
    }
    async findAllByName(search) {
        return this.keywordService.findByName(search);
    }
    async logicalRemoveKeyword(user, keywordId, companyId) {
        this.LOGGER.log(`logicalRemove keyword: ${keywordId} by user: ${user.id} companyid: ${companyId}`);
        await this.keywordService.logicalRemove(keywordId);
        await this.companyService.updateCheckTenders(companyId, true);
        return 'true';
    }
};
exports.KeywordController = KeywordController;
__decorate([
    (0, common_1.Get)(':search'),
    (0, swagger_1.ApiOkResponse)({ type: [domain_1.KeywordItem] }),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, swagger_1.ApiParam)({ name: 'search', type: 'string' }),
    __param(0, (0, common_1.Param)('search')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], KeywordController.prototype, "findAllByName", null);
__decorate([
    (0, common_1.Delete)(':keywordId/:companyId'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, swagger_1.ApiOkResponse)({ type: String }),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER),
    __param(0, (0, prime_user_decorator_1.PrimeUser)()),
    __param(1, (0, common_1.Param)('keywordId')),
    __param(2, (0, common_1.Param)('companyId')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [framework_1.User, Number, Number]),
    __metadata("design:returntype", Promise)
], KeywordController.prototype, "logicalRemoveKeyword", null);
exports.KeywordController = KeywordController = KeywordController_1 = __decorate([
    (0, common_1.Controller)('keyword'),
    (0, swagger_1.ApiTags)('keyword'),
    __param(0, (0, common_1.Inject)('KeywordService')),
    __param(1, (0, common_1.Inject)('CompanyService')),
    __metadata("design:paramtypes", [Object, Object])
], KeywordController);
//# sourceMappingURL=keyword.controller.js.map