import { User } from 'src/framework';
import { CompanyService } from 'src/licitaapp';
import { TenderService } from 'src/licitaapp/application/service/tender-service/tender-service.interface';
import { ActionReview, CompanyFullTO, CompanyRegisterTO, DashboardTO, HistoryTender, HistoryTenderDetail, Tender } from 'src/licitaapp/domain';
export declare class TendersController {
    private tenderService;
    private companyService;
    private readonly LOGGER;
    constructor(tenderService: TenderService, companyService: CompanyService);
    reviewTendersInfo(paramTO: ActionReview): Promise<String>;
    createCompany(user: User, company: CompanyRegisterTO): Promise<CompanyFullTO | null>;
    createDashboardCompany(user: User, companyId: number): Promise<String>;
    myDashboard(user: User, companyId: number): Promise<DashboardTO>;
    listHistoryTender(user: User): Promise<HistoryTender[]>;
    getHistoryPaginated(user: User, page: number, pageSize: number): Promise<HistoryTenderDetail[]>;
    getPaginatedTenders(user: User, page: number, pageSize: number, companyId: number, searchType: string, isFavorite: boolean, subdivisionId: number, monthRequest: string): Promise<Tender[]>;
    findByCode(user: User, code: string): Promise<Tender | null | undefined>;
    updateFavoriteUserCompanytender(user: User, tenderId: number, companyId: number, isFavorite: string): Promise<String>;
    logicalRemoveCompanyTenderUser(user: User, companyId: number, tenderId: number): Promise<String>;
    addTenderByCodeToCompany(companyId: number, code: string): Promise<String>;
}
