import { DBConfigService, TxType } from 'src/framework';
import { ApplicationLogRepository } from 'src/licitaapp/application/repository/application-log-repository/application-log-repository.interface';
import { InsertApplicationLog, ApplicationLog } from 'src/licitaapp/domain';
import { ApplicationTypeEnum } from 'src/licitaapp/domain/enum/enum.definition';
export declare class ApplicationLogRepositoryImpl implements ApplicationLogRepository {
    private readonly db;
    private readonly LOGGER;
    constructor(db: DBConfigService);
    save(applicationLog: InsertApplicationLog, tx?: TxType): Promise<number>;
    updateState(applicationLogId: number, statusTypeId: number, detail: string, tx?: TxType): Promise<boolean>;
    logicalRemove(applicationLogId: number, tx?: TxType): Promise<boolean>;
    findAll(page: number, pageSize: number, type?: ApplicationTypeEnum): Promise<ApplicationLog[]>;
}
