import { DBConfigService } from 'src/framework/infrastructure/drizzle';
import { HistoryTenderRepository } from 'src/licitaapp';
import { HistoryTender, TenderTO } from 'src/licitaapp/domain';
import { UserHistoryTenderRow } from 'src/licitaapp/domain/type/user-history-tender.types';
export declare class HistoryTenderRepositoryImpl implements HistoryTenderRepository {
    private readonly db;
    private readonly LOGGER;
    constructor(db: DBConfigService);
    erraseUserHistoryTender(tenderInfo: TenderTO): Promise<void>;
    save(userId: number, tenderId: number): Promise<boolean>;
    findByUserTender(userId: number, tenderId: number): Promise<UserHistoryTenderRow | undefined>;
    private selectUserHistoryTenderQuery;
    getListTenderHistory(userId: number): Promise<HistoryTender[]>;
}
