import { TxType } from 'src/framework';
import { DBConfigService } from 'src/framework/infrastructure/drizzle';
import { UserCompanyRepository } from 'src/licitaapp/application/repository/user-company-repository/user-company-repository.interface';
import { Company } from 'src/licitaapp/domain';
import { UserMinimalTO } from 'src/licitaapp/domain/dto/user.minimal.to';
export declare class UserCompanyRepositoryImpl implements UserCompanyRepository {
    private readonly db;
    private readonly LOGGER;
    constructor(db: DBConfigService);
    countUserByCompany(companyId: number): Promise<number>;
    getInfoUserCompany(companyId: number): Promise<UserMinimalTO[]>;
    getUserIdsWithActiveCompany(): Promise<number[]>;
    findCompaniesByUserId(userId: number): Promise<Company[]>;
    save(userId: number, companyId: number, tx?: TxType): Promise<boolean>;
    deleteByUserCompany(userId: number, companyId: number, tx?: TxType): Promise<void>;
    paginationByUser(userId: number, page: number, pageSize: number): Promise<Company[]>;
}
