"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var CompanyServiceImpl_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CompanyServiceImpl = void 0;
const common_1 = require("@nestjs/common");
const framework_1 = require("../../../../framework");
const drizzle_1 = require("../../../../framework/infrastructure/drizzle");
const domain_1 = require("../../../domain");
let CompanyServiceImpl = CompanyServiceImpl_1 = class CompanyServiceImpl {
    constructor(companyRepository, userCompanyService, keywordService, userCompanyTenderService, db) {
        this.companyRepository = companyRepository;
        this.userCompanyService = userCompanyService;
        this.keywordService = keywordService;
        this.userCompanyTenderService = userCompanyTenderService;
        this.db = db;
        this.LOGGER = new framework_1.PrimeLogger(CompanyServiceImpl_1.name);
    }
    async deleteByUserCompany(userId, companyId) {
        this.LOGGER.log(`deleteByUserCompany userId ${userId} companyId ${companyId}`);
        return await this.userCompanyService.deleteByUserCompany(userId, companyId);
    }
    async paginationByCompanyAdmin(page, pageSize) {
        this.LOGGER.log(`Paginating companies by admin, page: ${page}, pageSize: ${pageSize}`);
        const companies = await this.companyRepository.paginationByCompanyAdmin(page, pageSize);
        for (const company of companies) {
            const userInfo = await this.userCompanyService.getInfoUserCompany(company.companyId);
            company.listUsers = userInfo;
            company.amountTenders = await this.userCompanyTenderService.countActiveTendersCompany(company.companyId);
        }
        return companies;
    }
    async getCompanyIdsToRecalculateTender() {
        this.LOGGER.log('Getting company ids to recalculate tender');
        return await this.companyRepository.getCompanyIdsToRecalculateTender();
    }
    async getSubdivisionsByCompanyId(companyId) {
        this.LOGGER.log(`Getting subdivisions for companyId: ${companyId}`);
        return await this.companyRepository.getSubdivisionsByCompanyId(companyId);
    }
    async updateCheckTenders(companyId, checkTender) {
        this.LOGGER.log(`updateCheckTenders companyId ${companyId} checkTender ${checkTender}`);
        return await this.companyRepository.updateCheckTenders(companyId, checkTender);
    }
    async getAllWithouthMetadata() {
        this.LOGGER.log('Getting keywords metadata');
        return await this.keywordService.getAllWithouthMetadata();
    }
    async updateCompany(companyId, userId, updateCompany) {
        this.LOGGER.log(`Updating company: ${updateCompany.company.id}`);
        await this.db.conn.transaction(async (tx) => {
            const companyUpdated = await this.companyRepository.update(companyId, updateCompany, tx);
            if (!companyUpdated) {
                this.LOGGER.error('problem updating company');
                throw new Error('Problem updating company');
            }
            this.LOGGER.log('Deleted relations to subdivisions');
            await this.companyRepository.deletedCompanySubdivisions(companyId, tx);
            this.LOGGER.log('Set new relations to subdivisions');
            if ((updateCompany.listSubdivisions.length) > 0) {
                this.LOGGER.log(`Saving company subdivisions for company: ${companyId} `);
                const newSubdivisions = updateCompany.listSubdivisions.filter((subdivision) => subdivision.id !== 7777);
                this.LOGGER.log(`Subdivisions: ${JSON.stringify(updateCompany.listSubdivisions)}`);
                await this.companyRepository.saveCompanySubdivisions(companyId, newSubdivisions, tx);
            }
            this.LOGGER.log('deleting keywords');
            await this.keywordService.deleteByCompanyId(companyId, tx);
            this.LOGGER.log(`Set new relations to keywords size: ${updateCompany.listKeywords.length}`);
            if (updateCompany.listKeywords.length > 0) {
                await this.keywordService.saveAll(updateCompany.listKeywords.map((keyword) => ({
                    ...keyword,
                    companyId: +companyId,
                    metadata: undefined,
                })), userId, tx);
                this.LOGGER.log(`Saving keywords for company: ${companyId}`);
            }
        });
        return this.findByIdWithFetch(companyId);
    }
    async createCompany(userId, insertCompany) {
        this.LOGGER.log(`Creating company for user: ${userId}`);
        const newCompany = await this.db.conn.transaction(async (tx) => {
            var company = await this.findByDNI(insertCompany.company.dni);
            if (!company) {
                this.LOGGER.log(`Saving new company dni: ${insertCompany.company.dni}`);
                company = await this.companyRepository.save(insertCompany.company, tx);
            }
            if (!company) {
                this.LOGGER.error('Company not found');
                throw new Error('Company not found');
            }
            const companyId = company.id;
            const listSubdivisioneDB = await this.companyRepository.getSubdivisionsByCompanyId(company.id);
            listSubdivisioneDB.length > 0 &&
                this.LOGGER.log(`Adding more Subdivisions to company: ${company.id}`);
            if ((insertCompany?.listSubdivisions?.length ?? 0) > 0) {
                this.LOGGER.log(`Saving company subdivisions for company: ${company.id}`);
                const newSubdivisions = insertCompany.listSubdivisions.filter((subdivision) => !listSubdivisioneDB.some((existing) => existing.id === subdivision.id) && subdivision.id !== 7777);
                if (newSubdivisions.length > 0) {
                    await this.companyRepository.saveCompanySubdivisions(company.id, newSubdivisions, tx);
                }
            }
            const listKeywordsDB = await this.keywordService.findByCompanyId(company.id, false);
            if ((insertCompany?.listKeywords?.length ?? 0) > 0) {
                this.LOGGER.log(`Saving keywords for company: ${company.id}`);
                const newKeywords = insertCompany.listKeywords.filter((keyword) => !listKeywordsDB.some((existing) => existing.value === keyword.value));
                if (newKeywords.length > 0) {
                    await this.keywordService.saveAll(newKeywords.map((keyword) => ({
                        ...keyword,
                        companyId: companyId,
                        metadata: undefined,
                    })), userId, tx);
                }
            }
            this.LOGGER.log(`Saving user-company association for user: ${userId} and company: ${company.id}`);
            await this.userCompanyService.saveUserCompany(userId, company.id, tx);
            this.LOGGER.log(`Company created successfully: ${company.id}`);
            return company;
        });
        return this.findByIdWithFetch(newCompany.id);
    }
    async findByDNI(dni) {
        this.LOGGER.log(`Finding company by DNI: ${dni}`);
        return await this.companyRepository.findByDNI(dni);
    }
    async findById(id) {
        this.LOGGER.log(`Finding company by id: ${id}`);
        return await this.companyRepository.findById(id);
    }
    async findByIdWithFetch(id) {
        this.LOGGER.log(`Finding company with fetch by id: ${id}`);
        const company = await this.findById(id);
        if (!company) {
            this.LOGGER.warn(`Company not found by id: ${id}`);
            return null;
        }
        this.LOGGER.log(`Fetching keywords for company: ${company.id}`);
        const listKeywords = await this.keywordService.findByCompanyId(company.id, false);
        this.LOGGER.log(`Fetching subdivisions for company: ${company.id}`);
        const listSubdivisions = await this.companyRepository.getSubdivisionsByCompanyId(company.id);
        this.LOGGER.log(`Company with fetch found successfully: ${company.id}`);
        return new domain_1.CompanyFullTO(company, listKeywords.map((keyword) => {
            return {
                id: keyword.id,
                value: keyword.value,
                origin: keyword.origin,
                isSelected: true,
                metadata: keyword.metadata,
            };
        }), listSubdivisions);
    }
};
exports.CompanyServiceImpl = CompanyServiceImpl;
exports.CompanyServiceImpl = CompanyServiceImpl = CompanyServiceImpl_1 = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, common_1.Inject)('CompanyRepository')),
    __param(1, (0, common_1.Inject)('UserCompanyService')),
    __param(2, (0, common_1.Inject)('KeywordService')),
    __param(3, (0, common_1.Inject)('UserCompanyTenderService')),
    __metadata("design:paramtypes", [Object, Object, Object, Object, drizzle_1.DBConfigService])
], CompanyServiceImpl);
//# sourceMappingURL=company-service-impl.js.map