import { TxType } from 'src/framework';
import { KeywordRepository, KeywordService } from 'src/licitaapp/application';
import { MercadoPublicoGirosRepository } from 'src/licitaapp/application/mercado-publico/mp-giros/mercado-publico-giros.repository';
import { InsertKeyword, KeywordItem, Metadata } from 'src/licitaapp/domain';
export declare class KeywordServiceImpl implements KeywordService {
    private readonly keywordRepository;
    private readonly mpGiros;
    private readonly LOGGER;
    constructor(keywordRepository: KeywordRepository, mpGiros: MercadoPublicoGirosRepository);
    updateMetadata(keywordId: number, metadata: Metadata): Promise<void>;
    findByCompanyId(companyId: number, isNull: boolean, tx?: TxType): Promise<import("src/licitaapp/domain").Keyword[]>;
    getAllWithouthMetadata(tx?: TxType): Promise<import("src/licitaapp/domain").Keyword[]>;
    save(keyword: InsertKeyword, userId: number, tx?: TxType): Promise<import("src/licitaapp/domain").Keyword>;
    saveAll(keywords: InsertKeyword[], userId: number, tx?: TxType): Promise<import("src/licitaapp/domain").Keyword[]>;
    findByName(search: string): Promise<KeywordItem[]>;
    logicalRemove(keywordsId: number): Promise<void>;
    deleteByCompanyId(companyId: number, tx?: TxType): Promise<void>;
}
