"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var MatchWordsServiceImpl_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MatchWordsServiceImpl = void 0;
const common_1 = require("@nestjs/common");
const framework_1 = require("../../../../framework");
let MatchWordsServiceImpl = MatchWordsServiceImpl_1 = class MatchWordsServiceImpl {
    constructor() {
        this.LOGGER = new framework_1.PrimeLogger(MatchWordsServiceImpl_1.name);
    }
    findMatches(list1, list2) {
        this.LOGGER.debug(`findMatches list1 ${JSON.stringify(list1)} list2 ${JSON.stringify(list2)}`);
        const results = [];
        const normalizeText = (text) => text
            .toLowerCase()
            .normalize('NFD')
            .replace(/[\u0300-\u036f]/g, '')
            .replace(/[^a-z0-9 ]/g, '')
            .replace('de', '')
            .replace(' y ', '');
        const keywords = list2.map(normalizeText);
        for (const item of list1) {
            const normalizedItem = normalizeText(item);
            const itemWords = normalizedItem.split(' ');
            const matches = keywords.filter((keyword) => itemWords.some((word) => keyword.includes(word) || word.includes(keyword)));
            results.push({ item, matches });
        }
        return results;
    }
};
exports.MatchWordsServiceImpl = MatchWordsServiceImpl;
exports.MatchWordsServiceImpl = MatchWordsServiceImpl = MatchWordsServiceImpl_1 = __decorate([
    (0, common_1.Injectable)()
], MatchWordsServiceImpl);
//# sourceMappingURL=match-words-service-impl.js.map