"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var TenderFetcherServiceImpl_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TenderFetcherServiceImpl = void 0;
const common_1 = require("@nestjs/common");
const config_1 = require("@nestjs/config");
const moment = require("moment-timezone");
const framework_1 = require("../../../../framework");
const mp_repository_1 = require("../../../application/mercado-publico/mp.repository");
const enum_definition_1 = require("../../../domain/enum/enum.definition");
const util_1 = require("../../../domain/util");
const util_2 = require("util");
let TenderFetcherServiceImpl = TenderFetcherServiceImpl_1 = class TenderFetcherServiceImpl {
    constructor(configService, mercadoPublicoAPI, tenderService, applicationLogService) {
        this.configService = configService;
        this.mercadoPublicoAPI = mercadoPublicoAPI;
        this.tenderService = tenderService;
        this.applicationLogService = applicationLogService;
        this.LOGGER = new framework_1.PrimeLogger(TenderFetcherServiceImpl_1.name);
        this.maxRetries = this.configService.get('TENDER_FETCHER_MAX_RETRIES', 10);
        this.retryInterval = this.configService.get('TENDER_FETCHER_RETRY_INTERVAL', 1000);
        this.fetchFromDaysAgo = this.configService.get('TENDER_FETCHER_FETCH_FROM_DAYS_AGO', 90);
        this.enabled =
            this.configService.get('TENDER_FETCHER_ENABLED', 'false') === 'true';
    }
    async fetchTendersWithRetry(args) {
        const delay = (ms) => new Promise((resolve) => setTimeout(resolve, ms));
        for (let attempt = 1; attempt <= this.maxRetries; attempt++) {
            try {
                return await this.mercadoPublicoAPI.licitaciones(args);
            }
            catch (error) {
                if (attempt === Number(this.maxRetries)) {
                    throw error;
                }
                await delay(attempt * this.retryInterval);
            }
        }
    }
    async processTenders(args) {
        this.LOGGER.debug(`Fetching tenders with args: ${JSON.stringify(args)}`);
        const startTime = Date.now();
        const applicationLogId = await this.applicationLogService.save({
            userName: 'SYSTEM',
            statusTypeId: 8,
            detail: 'Iniciado a las ' + util_1.TenderUtil.getCurrentSystemDate().toLocaleTimeString(),
            type: enum_definition_1.ApplicationTypeEnum.SEARCH_TENDERS_MERCADO_PUBLICO_LOG,
        });
        try {
            const tenders = await this.fetchTendersWithRetry(args);
            if (tenders && tenders.Cantidad > 0) {
                let processed = 0;
                this.LOGGER.debug(`Fetched ${tenders.Cantidad} tenders. Processing...`);
                for (const tender of tenders.Listado) {
                    processed++;
                    this.LOGGER.debug(`Tender: ${tender.Nombre}, codigo ${tender.CodigoExterno}`);
                    try {
                        const codeDetails = await this.fetchTendersWithRetry({
                            codigo: tender.CodigoExterno,
                        });
                        if (codeDetails?.Listado) {
                            for (const tenderDetails of codeDetails.Listado) {
                                const trace = `Upserting tender: ${tenderDetails.CodigoExterno} processed ${processed}/${tenders.Cantidad} tiempo transcurrido: ${(Date.now() - startTime) / 1000} s.`;
                                this.LOGGER.debug(trace);
                                await this.applicationLogService.updateState(applicationLogId, 8, `${trace}. Trabajando...`);
                                await this.tenderService.upsert({
                                    code: tenderDetails.CodigoExterno,
                                    name: tenderDetails.Nombre,
                                    description: tenderDetails.Descripcion,
                                    details: tenderDetails,
                                    isFavorite: false,
                                });
                            }
                        }
                    }
                    catch (error) {
                        const duration = Date.now() - startTime;
                        await this.applicationLogService.updateState(applicationLogId, 9, `Duración: ${duration / 1000} s. Error: ${(0, util_2.inspect)(error)}.`);
                        this.LOGGER.error(`Error processing tenders for code ${tender.CodigoExterno} processed ${processed}/${tenders.Cantidad}`);
                        continue;
                    }
                }
                await this.applicationLogService.updateState(applicationLogId, 10, `processed ${processed}/${tenders.Cantidad} tiempo transcurrido: ${(Date.now() - startTime) / 1000} s.`);
            }
            else {
                this.LOGGER.debug(`No tenders found for args: ${JSON.stringify(args)}`);
            }
        }
        catch (error) {
            const duration = Date.now() - startTime;
            this.applicationLogService.updateState(applicationLogId, 9, `Duración: ${duration / 1000} s. Error: ${(0, util_2.inspect)(error)}.`);
            this.LOGGER.error(`Error processing tenders for args: ${JSON.stringify(args)}`);
            return false;
        }
        this.LOGGER.debug('Finished processing tenders');
        return true;
    }
    async fetchTendersOfTheDay() {
        if (!this.enabled) {
            this.LOGGER.log('Tender fetcher is disabled, skipping daily fetch.');
            return;
        }
        const now = moment().tz(TenderFetcherServiceImpl_1.TIMEZONE);
        const today = now.format('DDMMYYYY');
        const todayInWords = now.format('dddd, MMMM Do YYYY');
        this.LOGGER.debug(`Fetching tenders of the day ${todayInWords} (${TenderFetcherServiceImpl_1.TIMEZONE})...`);
        return await this.processTenders({ fecha: today });
    }
    async syncTenders() {
        if (!this.enabled) {
            return;
        }
        this.LOGGER.debug(`Fetching tenders of the last ${this.fetchFromDaysAgo} days...`);
        const today = moment().tz(TenderFetcherServiceImpl_1.TIMEZONE);
        for (let i = 0; i < this.fetchFromDaysAgo; i++) {
            const date = today.subtract(i, 'days').format('DDMMYYYY');
            await this.processTenders({ fecha: date });
        }
    }
};
exports.TenderFetcherServiceImpl = TenderFetcherServiceImpl;
TenderFetcherServiceImpl.TIMEZONE = 'America/Santiago';
exports.TenderFetcherServiceImpl = TenderFetcherServiceImpl = TenderFetcherServiceImpl_1 = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, common_1.Inject)('MercadoPublicoRepository')),
    __param(2, (0, common_1.Inject)('TenderService')),
    __param(3, (0, common_1.Inject)('ApplicationLogService')),
    __metadata("design:paramtypes", [config_1.ConfigService,
        mp_repository_1.MercadoPublicoRepository, Object, Object])
], TenderFetcherServiceImpl);
//# sourceMappingURL=tender-fetcher-service-impl.js.map