import { HttpService } from '@nestjs/axios';
import { ConfigService } from '@nestjs/config';
import { FirebaseService, GeoService, User, UserRequestService, UserService } from 'src/framework';
import { NotificationRecordService } from 'src/framework/application/service/notification-record-service/notification-record-service.interface';
import { CompanyService, KeywordService, TenderRepository, UserCompanyService } from 'src/licitaapp/application';
import { ApplicationLogService } from 'src/licitaapp/application/service/application-log-service/application-log-service.interface';
import { HistoryTenderService } from 'src/licitaapp/application/service/history-tender-service/history-tender-service.interface';
import { MatchWordsService } from 'src/licitaapp/application/service/match-words-service/match-words-service.interface';
import { TenderService } from 'src/licitaapp/application/service/tender-service/tender-service.interface';
import { UserCompanyTenderService } from 'src/licitaapp/application/service/user-company-tender-service/user-company-tender-service.interface';
import { Tender, DashboardTO, ParamsNotificationTO, Licitacion, HistoryTender, InsertTender, HistoryTenderDetail } from 'src/licitaapp/domain';
import { CompanyUserTO } from 'src/licitaapp/domain/dto/company.user.to';
import { ApplicationTypeEnum } from 'src/licitaapp/domain/enum/enum.definition';
export declare class TenderServiceImpl implements TenderService {
    private readonly tenderRepository;
    private readonly companyService;
    private readonly userHistoryTenderService;
    private readonly matchWordsService;
    private readonly userCompanyTenderRepository;
    private readonly notificationRecordService;
    private readonly geoService;
    private readonly configService;
    private readonly httpService;
    private readonly firebaseService;
    private readonly keywordService;
    private readonly userService;
    private readonly applicationLogService;
    private readonly userCompanyService;
    private readonly userRequestService;
    private readonly LOGGER;
    private readonly maxTextRetries;
    private readonly textApiKey;
    private readonly textApiUrl;
    private readonly tenderLimitDays;
    private readonly isCronActive;
    constructor(tenderRepository: TenderRepository, companyService: CompanyService, userHistoryTenderService: HistoryTenderService, matchWordsService: MatchWordsService, userCompanyTenderRepository: UserCompanyTenderService, notificationRecordService: NotificationRecordService, geoService: GeoService, configService: ConfigService, httpService: HttpService, firebaseService: FirebaseService, keywordService: KeywordService, userService: UserService, applicationLogService: ApplicationLogService, userCompanyService: UserCompanyService, userRequestService: UserRequestService);
    erraseOldTenders(): Promise<string>;
    tenderTaskPerDay(): Promise<void>;
    getListTenderHistory(userId: number): Promise<HistoryTender[]>;
    logicalRemoveCompanyTenderUser(userId: number, companyId: number, tenderId: number): Promise<void>;
    updateFavoriteUserCompanytender(userId: number, companyId: number, tenderId: number, isFavorite: boolean): Promise<void>;
    upsert(tender: InsertTender): Promise<number>;
    tenderTaskByHour(): Promise<void>;
    private logAndExecute;
    private evalTextLarge;
    checkTenderFavoritesToClose(applicationLogId: number): Promise<string>;
    checkNewTendersUserCompany(applicationLogId: number): Promise<string>;
    tenderTaskBy2Hour(): Promise<void>;
    private createApplicationLogID;
    tenderTaskEvery5Minutes(): Promise<void>;
    checkTenderSubdivision(applicationLogId: number): Promise<string>;
    private isPrime;
    checkCloseDate(applicationLogId: number): Promise<string>;
    checkMetadataKeywords(applicationLogId: number): Promise<string>;
    checkTenderWithCloseDate(applicationLogId: number): Promise<string>;
    tenderTaskPerMinutes(): Promise<void>;
    createDashboardCompany(companyId: number, userId: number): Promise<void>;
    searchTenderToUserCompanyWithSubdivision(companyId: number, userId: number): Promise<void>;
    reviewTenderWihoutMetadata(applicationLogId: number): Promise<string>;
    reviewTenderStatus(applicationLogId: number): Promise<string>;
    reviewTendersInfo(action: ApplicationTypeEnum): Promise<void>;
    private createResponseTenderMetadata;
    sendEmailSumaryToAdmin(applicationLogId: number): Promise<string>;
    private createRequestTextTender;
    evalStateTender(detail: Licitacion): boolean;
    private findSubdivision;
    private normalizeString;
    getTenderByCode(code: string, userId?: number): Promise<Tender | undefined>;
    addTenderByCodeToCompany(code: string, companyId: number): Promise<string>;
    generateInfoDashboard(user: User, companyId: number): Promise<DashboardTO>;
    getPaginatedTenders(userId: number, companyId: number, page: number, pageSize: number, searchType: string, subdivisionId: number, monthRequest: string): Promise<Tender[]>;
    getPaginatedHistoryTenders(userId: number, page: number, pageSize: number): Promise<HistoryTenderDetail[]>;
    searchTendersDB(params: ParamsNotificationTO, waitMinutes?: boolean): Promise<String>;
    private evalResultsMatch;
    private getListOfWordsMetada;
    fetchRazorMetadata(textToEval: string): Promise<any>;
    recalculteTender(applicationLogId: number): Promise<string>;
    paginationByCompanyAdmin(page: number, pageSize: number): Promise<CompanyUserTO[]>;
}
