import { InsertTypeMaster, TypeMaster } from 'src/framework/domain';
import { TxType } from 'src/framework/infrastructure';

export interface TypeMasterRepository {
  findByDiscriminator(
    discriminator: string,
    tx?: TxType,
  ): Promise<TypeMaster | null>;
  findById(id: number, tx?: TxType): Promise<TypeMaster | null | undefined>;
  findByShortName(shortName: string, tx?: TxType): Promise<TypeMaster | null>;
  save(typeMaster: InsertTypeMaster, tx?: TxType): Promise<TypeMaster>;
}
