import { TxType } from 'src/framework';
import { InsertUserDevice, UserDevice } from 'src/framework/domain/entities/user-device.entity';

export interface UserDeviceRepository {
  logicalRemoveById(id: number, tx?: TxType): Promise<void>;
  findByUserId(userId: number, tx?: TxType): Promise<string[]>;
  findUserWithToken(
    userId: number,
    token: string,
    tx?: TxType,
  ): Promise<UserDevice | null | undefined>;
  getAdminUserDeviceTokens(): Promise<string[]>;
  findById(id: number, tx?: TxType): Promise<UserDevice | null | undefined>;
  save(
    userId: number,
    userDevice: InsertUserDevice,
    tx?: TxType,
  ): Promise<UserDevice>;
  erraseUserDevice(token: string): Promise<void>;
}
