import { TxType, InsertUser, Role, UpdateUser, User, UserPage } from "src/framework";
import { RoleShortNameEnum } from "src/framework/infrastructure/decorators/allow-profiles/allow-roles.decorator";

export interface UserRepository {
  findAll(): Promise<User[]>;
  findById(id: number, tx?: TxType): Promise<User | null | undefined>;
  findByExternalId(externalId: string): Promise<User | null | undefined>;
  findByEmail(email: string): Promise<User | null | undefined>;
  save(user: InsertUser): Promise<User>;
  update(id: number, user: UpdateUser): Promise<User>;
  updateAggrement(user : User): Promise<string>;
  unsubscribe(userId: number): Promise<User>;
  findEmailsAdmin(userIds: number[]): Promise<string[]>;
  erraseAccount(userId: number): Promise<boolean>;
}
