import { AdministrativeDivision, Country } from "src/framework/domain";
import { Subdivision } from "src/framework/domain/entities/subdivision.entity";

export interface GeoService {
  findCountries(): Promise<Country[]>;
  findCountryById(id: number): Promise<Country | null>;
  findSubdivisionsByCountryCode(countryCode: string): Promise<Subdivision[]>;
  findAdmdivisionsByCountry(prefix: string): Promise<AdministrativeDivision[]>;
  findAdmdivisionsBySubdivisionCode(subdivisionCode: number): Promise<AdministrativeDivision[]>;
  findSubdivisionsByCountryCode(countryCode: string): Promise<Subdivision[]>;
}
