import { ApiProperty } from "@nestjs/swagger";
import { RoleShortNameEnum } from "src/framework/infrastructure/decorators/allow-profiles/allow-roles.decorator";

export class UserRoleTO {
    @ApiProperty({
        description: 'user id',
        example: 1545,
        required: true,
    })
    userId: number;
    
    @ApiProperty({
        description: 'profile short name',
        example: 'profile.admin',
        enum: RoleShortNameEnum,
        required: true,
    })
    profile: RoleShortNameEnum;  

    @ApiProperty({
        description: 'Indicates if the profile is added to the user',
        example: true,
        required: true,
    })
    isAdded: boolean;
}