import { ApiProperty, OmitType, PartialType } from '@nestjs/swagger';
import { RoleShortNameEnum } from 'src/framework/infrastructure/decorators/allow-profiles/allow-roles.decorator';

class Role {
  @ApiProperty({
    description: 'Role id',
    example: 1,
  })
  id: number;

  @ApiProperty({
    description: 'Role name',
    example: 'Administrator',
    required: false,
  })
  name: string;

  @ApiProperty({
    description: 'Role key search',
    example: RoleShortNameEnum.USER,
    enum: RoleShortNameEnum,
    enumName: 'RoleShortNameEnum',
  })
  shortName: RoleShortNameEnum;

  constructor(id: number, name: string, shortName: RoleShortNameEnum) {
    this.id = id;
    this.name = name;
    this.shortName = shortName;
  }
}

class InsertRole extends OmitType(Role, ['id']) {}

class UpdateRole extends PartialType(InsertRole) {}

export { InsertRole, Role, UpdateRole };
