import { ApiProperty, OmitType, PartialType } from '@nestjs/swagger';
import { TypeMasterDiscriminatorEnum } from '../enum/enum.definition';

class TypeMaster {
  @ApiProperty({
    description: 'TypeMaster id',
    example: 1,
  })
  id: number;

  @ApiProperty({
    description: 'TypeMaster name',
    example: 'John Doe',
  })
  name: string;

  @ApiProperty({
    description: 'TypeMaster short name',
    example: 'tutorial.type.1',
  })
  shortName: string;

  @ApiProperty({
    description: 'TypeMaster type',
    example: TypeMasterDiscriminatorEnum.STATE_REQUEST_TYPE,
    enum: TypeMasterDiscriminatorEnum,
    enumName: 'TypeMasterDiscriminatorEnum',
  })
  discriminator: TypeMasterDiscriminatorEnum;

  @ApiProperty({ 
    description: 'TypeMaster order',
    example: '1' 
  })
  order: number;

  constructor(id: number, name: string, shortName: string, discriminator: TypeMasterDiscriminatorEnum, order: number) {
    this.id = id;
    this.name = name;
    this.shortName = shortName;
    this.discriminator = discriminator;
    this.order = order;
  }
  
}

class InsertTypeMaster extends OmitType(TypeMaster, ['id']) {}

class UpdateTypeMaster extends PartialType(InsertTypeMaster) {}

export { InsertTypeMaster, UpdateTypeMaster, TypeMaster };