import { Body, Controller, Get, Inject, Param, Post } from '@nestjs/common';
import { ApiBody, ApiOkResponse, ApiParam, ApiTags } from '@nestjs/swagger';
import {
  PrimeLogger,
  TypeMasterService,
  InsertTypeMaster,
  TypeMaster,
} from 'src/framework';
import { ApiDefaultResponses } from '../../decorators/api-default-responses/api-default-responses.decorator';
import {
  AllowRoles,
  RoleShortNameEnum,
} from '../../decorators/allow-profiles/allow-roles.decorator';

@ApiTags('type-master')
@Controller('type-master')
export class TypeMasterController {
  private readonly LOGGER = new PrimeLogger(TypeMasterController.name);
  constructor(
    @Inject('TypeMasterService')
    private readonly typeMasterService: TypeMasterService,
  ) {}
  @Post()
  @ApiDefaultResponses()
  @AllowRoles(RoleShortNameEnum.USER, RoleShortNameEnum.ADMIN)
  @ApiOkResponse({ type: TypeMaster })
  @ApiBody({ type: InsertTypeMaster })
  async save(@Body() user: InsertTypeMaster): Promise<TypeMaster> {
    this.LOGGER.log(`save - user: ${JSON.stringify(user)}`);
    return await this.typeMasterService.createTypeMaster(user);
  }

  @Get(':id')
  @ApiDefaultResponses()
  @AllowRoles(RoleShortNameEnum.USER, RoleShortNameEnum.ADMIN)
  @ApiOkResponse({ type: TypeMaster })
  @ApiParam({ name: 'id', type: 'number' })
  async findById(
    @Param('id') id: number,
  ): Promise<TypeMaster | null | undefined> {
    this.LOGGER.log(`findById - id: ${id}`);
    return await this.typeMasterService.getTypeMasterById(id);
  }

  @Get(':discriminator')
  @ApiDefaultResponses()
  @AllowRoles(RoleShortNameEnum.USER, RoleShortNameEnum.ADMIN)
  @ApiOkResponse({ type: TypeMaster })
  @ApiParam({ name: 'discriminator', type: 'string' })
  async findByDiscriminator(
    @Param('discriminator') id: string,
  ): Promise<TypeMaster | null | undefined> {
    this.LOGGER.log(`findByDiscriminator - discriminator: ${id}`);
    return await this.typeMasterService.getTypeMasterByDiscriminator(id);
  }
}
