import { SetMetadata } from '@nestjs/common';

const ALLOWED_ROLES = 'allowedRoles';

/**
 * Enum representing rol short names.
 */
enum RoleShortNameEnum {
  USER = 'profile.normal.user',
  ADMIN = 'profile.normal.admin',
  MANAGER = 'profile.super.manager',
}

/**
 * Custom decorator to allow specific rols.
 *
 * @param shortNames - Array of rol short names to allow.
 * @returns A decorator function that sets metadata for allowed rols.
 */
const AllowRoles = (...shortNames: RoleShortNameEnum[]) =>
  SetMetadata(ALLOWED_ROLES, shortNames);

export { ALLOWED_ROLES, AllowRoles, RoleShortNameEnum };
