import { applyDecorators } from '@nestjs/common';
import { ApiBadRequestResponse } from '@nestjs/swagger';

import { Public } from '../public/public.decorator';
import { ApiErrorExamples, ApiErrorResponse } from '../../definition';

/**
 * A custom decorator that applies default public API response decorators to an endpoint.
 *
 * This decorator adds the following responses:
 * - 400 Bad Request
 *
 * It also marks the endpoint as public (no authentication required).
 *
 * @returns {Function} A function that applies the decorators.
 */
const ApiPublicResponses = () => {
  return applyDecorators(
    ApiBadRequestResponse({
      type: ApiErrorResponse,
      example: ApiErrorExamples.BAD_REQUEST,
    }),
    Public(),
  );
};

export { ApiPublicResponses };
