import { Logger as NestLogger } from '@nestjs/common';
import { DrizzleLogger } from './drizzle.logger';

describe('DrizzleLogger', () => {
  let drizzleLogger: DrizzleLogger;

  beforeEach(() => {
    jest.spyOn(NestLogger, 'debug').mockImplementation(() => {});
    drizzleLogger = new DrizzleLogger(true, 'prefix');
  });

  afterEach(() => {
    jest.clearAllMocks();
  });

  it('should not log query if shouldLog is not provided', () => {
    const logger = new DrizzleLogger();
    logger.logQuery('SELECT * FROM users', []);
    expect(NestLogger.debug).not.toHaveBeenCalled();
  });

  it('should not log query if shouldLog is false', () => {
    const logger = new DrizzleLogger(false);
    logger.logQuery('SELECT * FROM users', []);
    expect(NestLogger.debug).not.toHaveBeenCalled();
  });

  it('should log query if shouldLog is true', () => {
    drizzleLogger.logQuery('SELECT * FROM users', []);
    expect(NestLogger.debug).toHaveBeenCalled();
  });

  it('should replace param prefix in query if paramPrefix is provided', () => {
    drizzleLogger.logQuery('SELECT * FROM users WHERE id = $1', ['1']);
    expect(NestLogger.debug).toHaveBeenCalledWith(
      'Query: SELECT * FROM users WHERE id = prefix1; with params: ["1"]',
      'DrizzleModule',
    );
  });
});
