import { CacheModule } from '@nestjs/cache-manager';
import { Module } from '@nestjs/common';
import { FwkCacheServiceImpl } from '../../service/fwk-cache-service-impl/fwk-cache-service-impl';

@Module({
    imports: [
        CacheModule.register({
            ttl: 300000, // five minutes
            max: 300, // maximum items in memory
            isGlobal: true,
        }),
    ],
    controllers: [],
    providers: [
        {
          provide: 'FwkCacheService',
          useClass: FwkCacheServiceImpl,
      },
      ],
      exports: [
        'FwkCacheService',
      ],
})
export class FwkCacheModule {}
