import { Module } from '@nestjs/common';
import { DrizzleModule } from 'src/framework/infrastructure/drizzle';
import { UserRolRepositoryImpl } from 'src/framework/infrastructure/repository/user-rol-repository-impl/user-rol-repository-impl';
import { UserRoleImplService } from 'src/framework/infrastructure/service/user-role-service-impl/user-role-impl.service';
import { RoleModule } from '../role/role.module';

@Module({
    imports: [DrizzleModule, RoleModule],
    providers: [
        {
            provide: 'UserRoleService',
            useClass: UserRoleImplService,
        },
        {
            provide: 'UserRoleRepository',
            useClass: UserRolRepositoryImpl,
        }
    ],
    exports: [
        'UserRoleService',
        'UserRoleRepository',
    ],
})
export class UserRoleModule {}
