import { Injectable } from '@nestjs/common';
import { RoleRepository } from 'src/framework/application';
import { Role } from 'src/framework/domain';
import { DBConfigService } from 'src/framework/infrastructure/drizzle';
import * as schema from 'src/framework/infrastructure/drizzle/migrations/schema';
import { eq } from 'drizzle-orm';
import { RoleShortNameEnum } from '../../decorators/allow-profiles/allow-roles.decorator';
import { PrimeLogger } from '../../definition';

@Injectable()
export class RoleRepositoryImpl implements RoleRepository {
    private readonly LOGGER = new PrimeLogger(RoleRepositoryImpl.name);
    constructor(private readonly db: DBConfigService) {}
    async getRoleByKey(shortName: RoleShortNameEnum): Promise<Role> {
    this.LOGGER.log(`getRoleByKey shortName ${shortName}`);
        return await this.db.conn
      .select({
        id: schema.roleTable.id,
        name: schema.roleTable.name,
        shortName: schema.roleTable.shortName,
      })
      .from(schema.roleTable)
      .where(eq(schema.roleTable.shortName, shortName))
      .then((rows) => {
        if (rows.length === 0) {
          throw new Error(`Role with shortName ${shortName} not found`);
        }
        return new Role(rows[0].id, rows[0].name, rows[0].shortName);
      });
    }


}
