import { Inject, Injectable } from '@nestjs/common';
import { GeoRepository } from 'src/framework/application/repository/geo-repository/geo-repository.interface';
import { GeoService } from 'src/framework/application/service/geo-service/geo-service.interface';
import { PrimeLogger } from '../../definition';

@Injectable()
export class GeoServiceImpl implements GeoService {
  private readonly LOGGER = new PrimeLogger(GeoServiceImpl.name);
  constructor(
    @Inject('GeoRepository') private readonly repository: GeoRepository,
  ) {}
  async findCountries() {
    this.LOGGER.log('Finding all countries');
    return await this.repository.findCountries();
  }

  async findCountryById(id: number) {
    this.LOGGER.log(`Finding country by id: ${id}`);
    return await this.repository.findCountryById(id);
  }

  async findSubdivisionsByCountryCode(countryCode: string) {
    this.LOGGER.log(`Finding subdivisions by country code: ${countryCode}`);
    return await this.repository.findSubdivisionsByCountryCode(countryCode);
  }

  async findAdmdivisionsBySubdivisionCode(subdivisionCode: number) {
    this.LOGGER.log(
      `Finding administrative divisions by subdivision code: ${subdivisionCode}`,
    );
    return await this.repository.findAdmdivisionsBySubdivisionCode(
      subdivisionCode,
    );
  }
  async findAdmdivisionsByCountry(prefix: string) {
    this.LOGGER.log(
      `Finding administrative divisions by country prefix: ${prefix}`,
    );
    return await this.repository.findAdmdivisionsByCountry(prefix);
  }
}
