import { Inject, Injectable } from '@nestjs/common';
import { RoleService, RoleRepository } from 'src/framework/application';
import { Role, UserRoleTO } from 'src/framework/domain';
import { RoleShortNameEnum } from '../../decorators/allow-profiles/allow-roles.decorator';
import { PrimeLogger } from '../../definition';


@Injectable()
export class RolServiceImplService implements RoleService {
    private readonly LOGGER = new PrimeLogger(RolServiceImplService.name);
    constructor(@Inject('RoleRepository') private readonly roleRepository: RoleRepository) {}
    async getRoleByKey(shortName: RoleShortNameEnum): Promise<Role> {
        this.LOGGER.log(`getRoleByKey shortName ${shortName}`);
        return await this.roleRepository.getRoleByKey(shortName);
    }
}
