import { Inject, Injectable } from '@nestjs/common';
import { TypeMasterRepository } from 'src/framework/application/repository/type-master-repository/type-master-repository.interface';
import { TypeMasterService } from 'src/framework/application/service/type-master-service/type-master-service.interface';
import { InsertTypeMaster, TypeMaster } from 'src/framework/domain';
import { PrimeLogger } from '../../definition/logger/app.exception.logger';

@Injectable()
export class TypeMasterServiceImpl implements TypeMasterService {
    private readonly LOGGER = new PrimeLogger(TypeMasterServiceImpl.name);
    constructor(@Inject('TypeMasterRepository') private readonly typeMasterRepository: TypeMasterRepository) {}
    async createTypeMaster(typeMaster: InsertTypeMaster): Promise<TypeMaster> {
        this.LOGGER.log(`createTypeMaster - typeMaster: ${JSON.stringify(typeMaster)}`);
        return await this.typeMasterRepository.save(typeMaster);
    }

    async getTypeMasterById(id: number): Promise<TypeMaster | null | undefined> {
        this.LOGGER.log(`getTypeMasterById - id: ${id}`);
        return await this.typeMasterRepository.findById(id);
    }

    async getTypeMasterByDiscriminator(discriminator: string): Promise<TypeMaster | null> {
        this.LOGGER.log(`getTypeMasterByDiscriminator - discriminator: ${discriminator}`);
        return await this.typeMasterRepository.findByDiscriminator(discriminator);
    }

    async findByShortName(shortName: string): Promise<TypeMaster | null> {
    this.LOGGER.log(`findByShortName - shortName: ${shortName}`);
        return await this.typeMasterRepository.findByShortName(shortName);
    }
}
