import { HttpModuleOptions, HttpModuleOptionsFactory } from '@nestjs/axios';
import { Injectable } from '@nestjs/common';
import { ConfigService } from '@nestjs/config';

@Injectable()
export class MercadoPublicoGirosHttpConfigService
  implements HttpModuleOptionsFactory
{
  constructor(private configService: ConfigService) {}

  createHttpOptions(): HttpModuleOptions {
    return {
      baseURL: this.configService.get<string>('MP_GIROS_API_URL'),
      timeout: this.configService.get<number>('MP_GIROS_API_TIMEOUT', 5000),
      maxRedirects: this.configService.get<number>(
        'MP_GIROS_API_MAX_REDIRECTS',
        5,
      ),
    };
  }
}
