import * as moment from 'moment-timezone';

const CHILE_TIMEZONE = 'America/Santiago';

function convertDates<T>(obj: T, defaultTimezone: string = CHILE_TIMEZONE): T {
  if (Array.isArray(obj)) {
    return obj.map((item) =>
      convertDates(item, defaultTimezone),
    ) as unknown as T;
  } else if (obj !== null && typeof obj === 'object') {
    return Object.keys(obj).reduce((acc, key) => {
      const value = (obj as any)[key];
      if (typeof value === 'string' && key.startsWith('Fecha')) {
        if (value.endsWith('Z')) {
          acc[key] = new Date(value);
        } else {
          acc[key] = moment.tz(value, defaultTimezone).toDate();
        }
      } else {
        acc[key] = convertDates(value, defaultTimezone);
      }
      return acc;
    }, {} as any) as T;
  }
  return obj;
}

export { convertDates };
