import { TxType } from "src/framework";
import { InsertKeyword, Keyword, Metadata, UpdateKeyword } from "src/licitaapp/domain";

export interface KeywordRepository {

  deleteByCompanyId(companyId: number, tx?: TxType): Promise<void>;
  logicalRemove(id: number, tx?: TxType): Promise<void>;

  findById(id: number, tx?: TxType): Promise<Keyword | null | undefined>;
  findByCompanyId(companyId: number, isNullMetadata: boolean, tx?: TxType): Promise<Keyword[]>;
  getAllWithouthMetadata(tx?: TxType): Promise<Keyword[]>;

  updateMetadata(keywordId: number, metadata: Metadata): Promise<void>;

  save(keyword: InsertKeyword, userId: number, tx?: TxType): Promise<Keyword>;
  saveAll(keywords: InsertKeyword[], userId: number, tx?: TxType): Promise<Keyword[]>;
}
