import { Subdivision } from "src/framework/domain/entities/subdivision.entity";
import { Company, CompanyFullTO, CompanyRegisterTO } from "src/licitaapp/domain";

import { CompanyUserTO } from "src/licitaapp/domain/dto/company.user.to";

export interface CompanyService {
    createCompany(userId: number, insertCompany: CompanyRegisterTO): Promise<CompanyFullTO | null>;
    findByDNI(dni: string): Promise<Company | null>;
    findById(id: number): Promise<Company | null>;
    findByIdWithFetch(id: number): Promise<CompanyFullTO | null>;
    getCompanyIdsToRecalculateTender(): Promise<number[]>;
    getSubdivisionsByCompanyId(companyId: number): Promise<Subdivision[]>;
    paginationByCompanyAdmin(page: number, pageSize: number): Promise<CompanyUserTO[]>;
    updateCheckTenders(companyId: number, checkTender: boolean): Promise<boolean>;
    updateCompany(companyId: number, userId: number, updateCompany: CompanyRegisterTO): Promise<CompanyFullTO | null>;
}
