import { TxType } from "src/framework";
import { InsertKeyword, Keyword, KeywordItem, Metadata } from "src/licitaapp/domain";

export interface KeywordService {
    deleteByCompanyId(companyId: number, tx?: TxType): Promise<void>;
    logicalRemove(keywordsId: number): Promise<void>;

    findByName(search: string): Promise<KeywordItem[]>;
    findByCompanyId(companyId: number, isNull: boolean, tx?: TxType): Promise<Keyword[]>;
    getAllWithouthMetadata(tx?: TxType): Promise<Keyword[]>;

    save(keyword: InsertKeyword, userId: number, tx?: TxType): Promise<Keyword>;
    saveAll(keywords: InsertKeyword[], userId: number, tx?: TxType): Promise<Keyword[]>;

    updateMetadata(keywordId: number, metadata: Metadata): Promise<void>;
}
