import { LicitacionesQueryParams, LicitacionesResponse } from "../../mercado-publico";

export interface TenderFetcherService {
    fetchTendersWithRetry(args: LicitacionesQueryParams): Promise<LicitacionesResponse | undefined>;
    processTenders(args: LicitacionesQueryParams): Promise<boolean>;
    /**
     * Rescata las licitaciones del día actual desde el servicio de Mercado Público.
     */
    fetchTendersOfTheDay(): Promise<boolean | undefined>;
    /**
     * Rescata licitaciones pasadas en base a TENDERS_LIMIT_DAYS desde el servicio Mercado Público.
     */
    syncTenders(): Promise<void>;
}
